#include "cell.h"

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(LBSSuite) {
    Y_UNIT_TEST(ParseCells) {
        const TString stations = "3,0\n0,\"250,02,1e4b,ef5d,32,57\"\n1,\"250,02,1e4b,1a94,00,52\"\n2,\"250,02,1e4b,1a95,00,46\"\n3,\",,0000,ffff,00,41\"\n4,\",,0000,ffff,00,39\"\n5,\"250,02,1e51,7e30,00,38\"\n6,\"250,02,1e51,7e34,00,37\"\n\u000036\"\n\u000036\"\n";
        const auto cells = ParseCells(stations);
        UNIT_ASSERT(!cells.empty());
        UNIT_ASSERT_VALUES_EQUAL(cells.size(), 5);

        const auto& cell = cells[2];
        UNIT_ASSERT_VALUES_EQUAL(cell.MCC, 250);
        UNIT_ASSERT_VALUES_EQUAL(cell.MNC, 2);
        UNIT_ASSERT_VALUES_EQUAL(cell.LAC, 0x1e4b);
        UNIT_ASSERT_VALUES_EQUAL(cell.CellId, 0x1a95);
        UNIT_ASSERT_DOUBLES_EQUAL(cell.SignalLevel, 46, 0.1);
    }
}
