#include "formatter.h"

void NDrive::TLoggerFormatter::Format(const TLogRecordContext& context, TLogElement& elem) const {
    elem << NLoggingImpl::GetLocalTimeS() << '\t';
    elem << context.CustomMessage << '\t';
    elem << StripFilename(context.SourceLocation.File, 2) << ":" << context.SourceLocation.Line << '\t';
    if (context.Priority > TLOG_RESOURCES && !ExitStarted()) {
        elem << NLoggingImpl::GetSystemResources() << '\t';
    }
}

std::string_view NDrive::StripFilename(std::string_view filename, size_t count) {
    size_t current = 0;
    auto searched = filename;
    for (size_t i = 0; i < count; ++i) {
        auto p = searched.find_last_of(LOCSLASH_C);
        if (p == std::string_view::npos) {
            current = 0;
            break;
        }
        current = p + 1;
        searched = {
            searched.begin(),
            searched.begin() + p
        };
    }
    return {
        filename.begin() + current,
        filename.end()
    };
}
