#include "formatter.h"

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(DriveLogFormatter) {
    Y_UNIT_TEST(StripFilename) {
        {
            auto filename = "drive/library/cpp/logger/formatter_ut.cpp"sv;
            UNIT_ASSERT_VALUES_EQUAL(NDrive::StripFilename(filename, 0), filename);
            UNIT_ASSERT_VALUES_EQUAL(NDrive::StripFilename(filename, 1), "formatter_ut.cpp");
            UNIT_ASSERT_VALUES_EQUAL(NDrive::StripFilename(filename, 2), "logger/formatter_ut.cpp");
            UNIT_ASSERT_VALUES_EQUAL(NDrive::StripFilename(filename, 3), "cpp/logger/formatter_ut.cpp");
            UNIT_ASSERT_VALUES_EQUAL(NDrive::StripFilename(filename, 1000), filename);
        }
        {
            auto filename = "formatter_ut.cpp"sv;
            UNIT_ASSERT_VALUES_EQUAL(NDrive::StripFilename(filename, 0), filename);
            UNIT_ASSERT_VALUES_EQUAL(NDrive::StripFilename(filename, 1), filename);
            UNIT_ASSERT_VALUES_EQUAL(NDrive::StripFilename(filename, 2), filename);
            UNIT_ASSERT_VALUES_EQUAL(NDrive::StripFilename(filename, 3), filename);
            UNIT_ASSERT_VALUES_EQUAL(NDrive::StripFilename(filename, 1000), filename);
        }
    }
}
