#pragma once

#include <rtline/api/graph/router/router.h>

namespace NDrive {
    class TMapsLinker: public NGraph::ILinker {
    public:
        TMapsLinker(const TString& endpoint, TAtomicSharedPtr<NGraph::ILinker> relinker = nullptr);

        NThreading::TFuture<NGraph::TRouter::TMatch> Match(
            const NGraph::TRouter::TTimedGeoCoordinates& coordinates,
            const NGraph::TMatchingOptions& options = Default<NGraph::TMatchingOptions>()
        ) const override;

    private:
        NThreading::TFuture<NGraph::TRouter::TMatch> Rematch(NThreading::TFuture<NGraph::TRouter::TMatch>&& match, const NGraph::TMatchingOptions& options) const;

    private:
        const TString Endpoint;

        THolder<NNeh::THttpClient> Client;
        TAtomicSharedPtr<NGraph::ILinker> Relinker;
        TDuration RequestTimeout;
    };
}
