#include "linker.h"

#include <rtline/library/json/cast.h>

#include <library/cpp/testing/unittest/registar.h>

namespace {
    auto MakeCoordinates1() {
        NGraph::TRouter::TTimedGeoCoordinates coordinates;
        auto addCoordinate = [&] (float lon, float lat, TInstant timestamp) {
            coordinates.emplace_back(TGeoCoord{ lon, lat }, timestamp);
        };
        addCoordinate(30.45931244, 59.84840775, TInstant::Seconds(1616082651));
        addCoordinate(30.45915413, 59.84841919, TInstant::Seconds(1616082661));
        addCoordinate(30.45889091, 59.84845352, TInstant::Seconds(1616082671));
        addCoordinate(30.45866585, 59.84849548, TInstant::Seconds(1616082681));
        addCoordinate(30.45850754, 59.84856033, TInstant::Seconds(1616082691));
        return coordinates;
    }
}

Y_UNIT_TEST_SUITE(MapsLinker) {
    Y_UNIT_TEST(Simple) {
        NDrive::TMapsLinker client("http://core-jams-matcher.testing.maps.yandex.net");
        auto coordinates = MakeCoordinates1();
        auto asyncMatched = client.Match(coordinates);
        auto matched = asyncMatched.GetValueSync();
        UNIT_ASSERT(!matched.Elements.empty());
        Cerr << PrintRoute(matched) << Endl;
    }

    Y_UNIT_TEST(Rematching) {
        auto relinker = MakeHolder<NGraph::TRouter>("saas-searchproxy-maps-prestable.yandex.net", 17000, "drive_router");
        NDrive::TMapsLinker client("http://core-jams-matcher.testing.maps.yandex.net", std::move(relinker));
        auto coordinates = MakeCoordinates1();
        auto asyncMatched = client.Match(coordinates);
        auto matched = asyncMatched.GetValueSync();
        UNIT_ASSERT(!matched.Elements.empty());
        Cerr << PrintRoute(matched) << Endl;
    }
}
