#include "router.h"

#include <library/cpp/string_utils/base64/base64.h>
#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(PedestrianRouterIsochrone) {
    Y_UNIT_TEST(InvalidContent) {
        UNIT_CHECK_GENERATED_EXCEPTION(NDrive::ParsePedestrianIsochrone("invalid"), yexception);
    }
    Y_UNIT_TEST(Limeleft10MinutesContent) {
        TStringStream ss;
        ss << "EvEBMu4BKusBIugBCuUBCuIBCnEItoGDJBJq1AOwAtgBmhGwFqgPqArwApoxvDGuCFDOBfIGrAy2GKAG8AKiCdwH8gXOBtwPqgGo";
        ss << "Gv4E8A7YAYAE4QiyAu4H4wzLAskHywLnDnPFHYcJ5R/NBbM1iSDnBdUCnQvzBJUG4yDLCv8fkwe7AhJtCOTxnDUSZv4HsAaQApoU";
        ss << "7hTQF6gL4gHbBfgNnAUupAPfA+UGiQ3XAsUB2QTXAtUD2wPVBlWjCo8D6wtvxwL7E5cKgQ+1CNMBqwXJAcsNS+EPb68I3QK9AugB";
        ss << "jAO6AbAF/gHcAp4O7gHSAqwBXA==";
        auto area = NDrive::ParsePedestrianIsochrone(Base64Decode(ss.Str()));
        UNIT_ASSERT_VALUES_EQUAL(area.size(), 19);
        UNIT_ASSERT_VALUES_EQUAL(area.front(), area.back());
    }
    Y_UNIT_TEST(Limeleft20MinutesContent) {
        TStringStream ss;
        ss << "EtUDMtIDKs8DIswDCskDCsYDCuEBCKDGgSQS2QGgAlDMBvoC3grqAcYppg/ECoUNPtAIpARsvALWAc4G+C6IMfwN1BfAJ1rsLP0E";
        ss << "vAaCD5YKzAKKIPoeviygGsoP6ALMDogduAf6BtAEhhG2EKId0AXGDZQPzQG6DvQQsAPEAqgCfuwYlAO1CLcD/Qi3B9cNiQj5Be8H";
        ss << "+QXpCesEjwWNCt0KR90O9wf9BPkB3wqdDusI3QrLD8EKvwi1BL0EoTXDEvcDpwaBA48Fk0+DA4kDswkjrSyjFLsVkRj9BMkDmSGD";
        ss << "Gp8OlxGzFf0E3Q6XBqMQuw25Br0BEt8BCKS/nDUS1wGEBIQBrAvOCNQLtAPaDewJpiakCaQGpgieEcwD0AsKKLwK2geKA44I+gku";
        ss << "3CDAEcQE8giOBADwA9kE1RPbGc0FxQHtCocOtQH9AYsCpwbrBr0GjQPZCMkLqw6xGusMqQK3A/8J5wLVFMcCzQiHAvEFqwS1CN0E";
        ss << "7QTXCdEDowqNA4sDqwStBiPlCvkG6wKRAZkGwQqlBb8F5QmLBoEF0wK9AqcI8wqzAv8C4wGkAqsBAwXwBBSYGOAD5g7SBawC4gG8";
        ss << "C0WeA5gE6gTaAZYF6ALkBJADkgHgBA==";
        auto area = NDrive::ParsePedestrianIsochrone(Base64Decode(ss.Str()));
        UNIT_ASSERT_VALUES_EQUAL(area.size(), 23);
        UNIT_ASSERT_VALUES_EQUAL(area.front(), area.back());
    }
}
