#pragma once

#include <rtline/library/deprecated/async_impl/async_impl.h>

class TS3ClientConfig : public TAsyncApiImpl::TConfig {
public:
    enum class EBucketEncryptionMode {
        AES_GCM_128 = 0 /* "aes_gcm_128" */,
        AES_GCM_256 = 1 /* "aes_gcm_256" */,
    };

    class TEncryptedBucket {
    public:
        using TPtr = TAtomicSharedPtr<TEncryptedBucket>;

    private:
        R_READONLY(TString, Name);
        R_READONLY(TString, BucketName);
        R_READONLY(EBucketEncryptionMode, EncryptionMode, EBucketEncryptionMode::AES_GCM_128);
        R_READONLY(TString, EncryptionKeyPath);
        R_READONLY(TVector<unsigned char>, EncryptionKey);
        R_READONLY(bool, Default, false);

    public:
        TEncryptedBucket(const TString& name);
        void Init(const TYandexConfig::Section* section);
        void ToString(IOutputStream& os) const;
    };
    using TBucketsMap = std::multimap<TString, TEncryptedBucket::TPtr>;

private:
    R_READONLY(TString, AccessKeyIdPath);
    R_READONLY(TString, AccessKeyId);
    R_READONLY(TString, AccessSecretKeyPath);
    R_READONLY(TString, AccessSecretKey);
    R_READONLY(TString, OriginalHost);
    R_READONLY(TString, PublicBucketHost);
    R_READONLY(TDuration, RequestTimeout, TDuration::Seconds(1));
    R_READONLY(ui32, HandlerThreads, 4);
    R_READONLY(TSet<TString>, PublicBuckets, {});
    R_READONLY(TDuration, InitPeriod, TDuration::Seconds(60));
    R_READONLY(TBucketsMap, EncryptedBuckets);

public:
    void Init(const TYandexConfig::Section* section, const TMap<TString, NSimpleMeta::TConfig>* requestPolicy);
    void ToString(IOutputStream& os) const;

    static TS3ClientConfig ParseFromString(const TString& configStr) {
        return TAsyncApiImpl::TConfig::ParseFromString<TS3ClientConfig>(configStr);
    }

    TS3ClientConfig GetBucketConfig(const TString& bucketName) const;
    NNeh::THttpRequest CreateCommonRequest(const TString& authStr, const TString& date, const TString& method = "GET", const TString& postData = TString()) const;

    TString GetTmpFilePath(const TString& bucketName, const TString& path) const;

private:
    TString SignString(const TString& request) const;
};
