#pragma once

#include <rtline/util/network/neh.h>
#include <rtline/util/types/field.h>

#include <library/cpp/tvmauth/client/facade.h>

namespace NDrive {
    inline TString MediaBillingProductionEndpoint = "https://api.mediabilling.yandex.net";
    inline TString MediaBillingTestingEndpoint = "https://api.mt.mediabilling.yandex.net";

    inline NTvmAuth::TTvmId MediaBillingProductionClientId = 2001267;
    inline NTvmAuth::TTvmId MediaBillingTestingClientId = 2001265;

    class TMediaBillingClient {
    public:
        struct TProduct {
            TString Id;

            NJson::TJsonValue Raw;

            DECLARE_FIELDS(
                Field(Id, "id")
            );

            inline bool operator< (const TProduct& other) const {
                return Id < other.Id;
            }
        };
        struct TProductDescription {
            TProduct Product;
            bool Available = false;
            bool TrialAvailable = false;

            NJson::TJsonValue Raw;

            DECLARE_FIELDS(
                Field(Available, "available"),
                Field(TrialAvailable, "trialAvailable"),
                Field(Product, "product")
            );

            inline bool operator< (const TProductDescription& other) const {
                return std::tie(TrialAvailable, Available, Product) < std::tie(other.TrialAvailable, other.Available, other.Product);
            }
        };
        using TProducts = TVector<TProductDescription>;

        using TOrderId = ui64;
        struct TOrderInfo {
            TOrderId Id;
            TString Status;

            NJson::TJsonValue Raw;

            DECLARE_FIELDS(
                Field(Id, "orderId"),
                Field(Status, "status")
            );
        };

        struct TOptions {
            TString Endpoint = MediaBillingTestingEndpoint;
            TString GetOrderInfoHandle = "/internal-api/account/billing/order-info";
            TString GetProductsHandle = "/products/native-products";
            TString SubmitOrderHandle = "/subscription/submit-native-order";
            TDuration DefaultTimeout = TDuration::Seconds(10);
            NTvmAuth::TTvmId DestinationClientId = 0;
        };

    public:
        TMediaBillingClient(const TOptions& options, TAtomicSharedPtr<NTvmAuth::TTvmClient> tvm);

        NThreading::TFuture<TProducts> GetProducts(TStringBuf clientIp, TStringBuf uid, TStringBuf target) const;
        NThreading::TFuture<TOrderInfo> GetOrderInfo(TOrderId orderId, TStringBuf uid) const;
        NThreading::TFuture<TOrderInfo> SubmitOrder(
            TStringBuf productId,
            TStringBuf clientIp,
            TStringBuf uid,
            TStringBuf paymentMethodId,
            TStringBuf source,
            TStringBuf origin
        ) const;

    private:
        NTvmAuth::TTvmId GetClientId() const;
        NThreading::TFuture<NJson::TJsonValue> MakeRequest(const TString& method, const TString& handle, const TString& cgi) const;

    private:
        const TOptions Options;

        TAtomicSharedPtr<NNeh::THttpClient> HttpClient;
        TAtomicSharedPtr<NTvmAuth::TTvmClient> Tvm;
    };
}
