#include "api.h"

#include <library/cpp/json/json_reader.h>
#include <rtline/library/json/cast.h>
#include <rtline/library/json/parse.h>

template <>
NJson::TJsonValue NJson::ToJson(const NDrive::NMtApi::TErrorEntity& data) {
    NJson::TJsonValue json;
    json["deepLink"] = data.DeepLink;
    json["message"] = data.Message;
    json["errorCode"] = data.ErrorCode;
    return json;
}

template <>
bool NJson::TryFromJson(const NJson::TJsonValue& json, NDrive::NMtApi::TTokenDto& data) {
    return NJson::TryFromJson(json["phoneNum"], data.PhoneNum) &&
        NJson::TryFromJson(json["birthday"], data.Birthday);
}

template <>
NJson::TJsonValue NJson::ToJson(const NDrive::NMtApi::TTokenEntity& data) {
    NJson::TJsonValue json;
    if (data.Token) {
        json["token"] = data.Token;
    }
    if (data.ValidUntil != TInstant::Zero()) {
        json["validUntil"] = data.ValidUntil.Seconds();
    }
    return json;
}

template <>
bool NJson::TryFromJson(const NJson::TJsonValue& json, NDrive::NMtApi::TLocationDto& data) {
    return NJson::TryFromJson(json["lat"], data.Lat) &&
        NJson::TryFromJson(json["lon"], data.Lon);
}

template <>
bool NJson::TryFromJson(const NJson::TJsonValue& json, NDrive::NMtApi::TRideDto& data) {
    return NJson::TryFromJson(json["offerId"], data.OfferId) &&
        NJson::TryFromJson(json["carId"], data.CarId) &&
        NJson::TryFromJson(json["policyVersion"], data.PolicyVersion) &&
        NJson::TryFromJson(json["userLocation"], data.UserLocation);
}

template <>
bool NJson::TryFromJson(const NJson::TJsonValue& json, NDrive::NMtApi::TRideCancelRequestDto& data) {
    return NJson::TryFromJson(json["userLocation"], data.UserLocation);
}

template <>
bool NJson::TryFromJson(const NJson::TJsonValue& json, NDrive::NMtApi::TRideCancelConfirmDto& data) {
    return NJson::ParseField(json, "confirmationRequestId", data.ConfirmationRequestId);
}

template <>
NJson::TJsonValue NJson::ToJson(const NDrive::NMtApi::TFuelCapacity& data) {
    NJson::TJsonValue json;
    json["value"] = data.Value;
    json["type"] = data.Type;
    return json;
}

template <>
NJson::TJsonValue NJson::ToJson(const NDrive::NMtApi::TLocationEntity& data) {
    NJson::TJsonValue json;
    json["address"] = data.Address;
    json["lat"] = data.Lat;
    json["lon"] = data.Lon;
    return json;
}
template <>
NJson::TJsonValue NJson::ToJson(const NDrive::NMtApi::TRideCarEntity& data) {
    NJson::TJsonValue json;
    json["id"] = data.Id;
    json["fuelCapacity"] = NJson::ToJson(data.FuelCapacity);
    json["position"] = NJson::ToJson(data.Position);
    json["number"] = data.Number;
    json["model"] = data.Model;
    return json;
}

template <>
NJson::TJsonValue NJson::ToJson(const NDrive::NMtApi::TRideInfoEntity& data) {
    NJson::TJsonValue json;
    json["freeUntil"] = data.FreeUntil.Seconds();
    json["pricePerMin"] = data.PricePerMin;
    json["totalDuration"] = data.TotalDuration.Seconds();
    json["totalPrice"] = data.TotalPrice;
    return json;
}

template <>
NJson::TJsonValue NJson::ToJson(const NDrive::NMtApi::TRideSummaryInfoEntity& data) {
    NJson::TJsonValue json;
    json["totalDuration"] = data.TotalDuration.Seconds();
    json["totalPrice"] = data.TotalPrice;
    return json;
}

template <>
NJson::TJsonValue NJson::ToJson(const NDrive::NMtApi::TCarInsurancePolicyEntity& data) {
    NJson::TJsonValue json;
    json["description"] = data.Description;
    return json;
}

template <>
NJson::TJsonValue NJson::ToJson(const NDrive::NMtApi::TOfferRangePriceEntity& data) {
    NJson::TJsonValue json;
    json["min"] = data.Min;
    json["max"] = data.Max;
    return json;
}

template <>
NJson::TJsonValue NJson::ToJson(const NDrive::NMtApi::TOfferRangeEntity& data) {
    NJson::TJsonValue json;
    json["id"] = data.Id;
    json["name"] = data.Name;
    json["description"] = data.Description;
    json["insurancePolicy"] = NJson::ToJson(data.InsurancePolicy);
    json["prePaymentInformation"] = data.PrePaymentInformation;
    json["usagePrice"] = data.UsagePrice;
    json["holdAmount"] = data.HoldAmount;
    json["freeWaitingTime"] = data.FreeWaitingTime.Seconds();
    json["offerWaiting"] = NJson::ToJson(data.Waiting);
    json["offerParking"] = NJson::ToJson(data.Parking);
    json["offerRiding"] = NJson::ToJson(data.Riding);
    json["offerInspection"] = NJson::ToJson(data.Inspection);
    json["freeInspectionTime"] = data.FreeInspectionTime.Seconds();
    json["validUntil"] = data.ValidUntil.Seconds();
    return json;
}

template <>
NJson::TJsonValue NJson::ToJson(const NDrive::NMtApi::TRideEntity& data) {
    NJson::TJsonValue json;
    json["id"] = data.Id;
    json["deepLink"] = data.DeepLink;
    if (data.SpecialMessage) {
        json["specialMessage"] = data.SpecialMessage;
    }
    json["car"] = NJson::ToJson(data.Car);
    json["offer"] = NJson::ToJson(data.Offer);
    json["waitingInfo"] = NJson::ToJson(data.WaitingInfo);
    json["inspectionInfo"] = NJson::ToJson(data.InspectionInfo);
    json["drivingInfo"] = NJson::ToJson(data.DrivingInfo);
    json["parkingInfo"] = NJson::ToJson(data.ParkingInfo);
    json["summaryInfo"] = NJson::ToJson(data.SummaryInfo);
    json["pointStart"] = NJson::ToJson(data.PointStart);
    json["pointFinish"] = NJson::ToJson(data.PointFinish);
    json["createdAt"] = data.CreatedAt.Seconds();
    json["startedAt"] = data.StartedAt.Seconds();
    if (data.FinishedAt) {
        json["finishedAt"] = data.FinishedAt.Seconds();
    }
    if (data.CanceledAt) {
        json["canceledAt"] = data.CanceledAt.Seconds();
    }
    json["status"] = NJson::ToJson(data.Status);
    return json;
}

template <>
NJson::TJsonValue NJson::ToJson(const NDrive::NMtApi::TActiveRideInfoEntity& data) {
    NJson::TJsonValue json;
    json["status"] = data.Status;
    json["ride"] = NJson::ToJson(data.Ride);
    if (data.DeepLink) {
        json["deepLink"] = data.DeepLink;
    }
    return json;
}

template <>
NJson::TJsonValue NJson::ToJson(const NDrive::NMtApi::TZoneEntity& data) {
    NJson::TJsonValue json;
    json["geojson"] = data.GeoJson.ToJson();
    json["shortDescription"] = data.ShortDescription;
    json["description"] = data.Description;
    json["name"] = data.Name;
    json["mapLabel"] = data.MapLabel;
    return json;
}

template <>
NJson::TJsonValue NJson::ToJson(const NDrive::NMtApi::TZoneSetEntity& data) {
    NJson::TJsonValue json;
    json["availableForDriving"] = data.AvailableForDriving.ToJson();
    json["forbiddenComplete"] = NJson::ToJson(data.ForbiddenComplete);
    json["allowComplete"] = NJson::ToJson(data.AllowComplete);
    return json;
}

template <>
NJson::TJsonValue NJson::ToJson(const NDrive::NMtApi::TCarZoneSetEntity& data) {
    NJson::TJsonValue json;
    json["setId"] = data.Id;
    json["setUpdatedAt"] = NJson::ToJson(data.UpdatedAt);
    return json;
}

template <>
NJson::TJsonValue NJson::ToJson(const NDrive::NMtApi::TCarZonesEntity& data) {
    NJson::TJsonValue json;
    json["availableForDriving"] = data.AvailableForDriving.ToJson();
    json["forbiddenComplete"] = NJson::ToJson(data.ForbiddenComplete);
    json["allowComplete"] = NJson::ToJson(data.AllowComplete);
    json["sets"] = NJson::ToJson(data.Sets);
    return json;
}

template <>
NJson::TJsonValue NJson::ToJson(const NDrive::NMtApi::TCarEntity& data) {
    NJson::TJsonValue json;
    json["id"] = data.Id;
    json["deepLink"] = data.DeepLink;
    json["fuelCapacity"] = NJson::ToJson(data.FuelCapacity);
    json["carNum"] = NJson::ToJson(data.Number);
    json["model"] = NJson::ToJson(data.Model);
    json["zones"] = NJson::ToJson(data.Zones);
    json["location"] = NJson::ToJson(data.Location);
    if (data.ForbiddenRentReason) {
        json["forbiddenRentReason"] = data.ForbiddenRentReason;
    }
    if (data.ForbiddenRentReasonMessage) {
        json["forbiddenRentReasonMessage"] = data.ForbiddenRentReasonMessage;
    }
    json["offer"] = NJson::ToJson(data.Offers);
    return json;
}

template <>
NJson::TJsonValue NJson::ToJson(const NDrive::NMtApi::TPolicyEntity& data) {
    NJson::TJsonValue json;
    json["content"] = data.Content;
    json["version"] = data.Version;
    return json;
}

template <>
NJson::TJsonValue NJson::ToJson(const NDrive::NMtApi::TRideCancelConfirmEntity& data) {
    NJson::TJsonValue json = NJson::JSON_MAP;
    if (data.Id) {
        json["id"] = data.Id;
        json["message"] = data.Message;
    }
    return json;
}
