#pragma once

#include <drive/library/cpp/geojson/value.h>
#include <library/cpp/json/writer/json_value.h>
#include <util/datetime/base.h>
#include <util/generic/maybe.h>
#include <util/generic/string.h>
#include <util/generic/vector.h>

namespace NDrive::NMtApi {

    static const TString UserNotFoundErrorCode = "userNotFound";
    static const TString RegistrationNotCompletedErrorCode = "registrationNotCompleted";
    static const TString BlockedErrorCode = "blocked";
    static const TString UserDebtErrorCode = "userDebt";
    static const TString OtherErrorCode = "other";

    static const TString WaitingRide = "waiting";
    static const TString InspectionRide = "inspection";
    static const TString ActiveRide = "active";
    static const TString ParkingRide = "parking";
    static const TString CancelingRide = "canceling";
    static const TString CanceledRide = "canceled";
    static const TString FinishedRide = "finished";
    static const TString UnknownRide = "unknown";

    struct TErrorEntity {
        TString DeepLink;
        TString Message;
        TString ErrorCode;
    };

    struct TTokenDto {
        i64 PhoneNum = 0;
        TInstant Birthday;
    };

    struct TTokenEntity {
        TString Token;
        TInstant ValidUntil;
    };

    using TErrorTokenCreationEntity = TErrorEntity;

    struct TLocationDto {
        double Lat = 0;
        double Lon = 0;
    };

    struct TRideDto {
        TString OfferId;
        TString CarId;
        TMaybe<TString> PolicyVersion;
        TLocationDto UserLocation;
    };

    struct TRideCancelRequestDto {
        TLocationDto UserLocation;
    };

    struct TRideCancelConfirmDto {
        TString ConfirmationRequestId;
    };

    struct TFuelCapacity {
        double Value = 0;
        TString Type;
    };

    struct TLocationEntity {
        TString Address;
        double Lat = 0;
        double Lon = 0;
    };

    struct TRideCarEntity {
        TString Id;
        TString Number;
        TFuelCapacity FuelCapacity;
        TLocationEntity Position;
        TString Model;
    };

    struct TRideInfoEntity {
        TInstant FreeUntil;
        i32 PricePerMin = 0;
        TDuration TotalDuration;
        i32 TotalPrice = 0;
    };

    using TRideWaitingInfoEntity = TRideInfoEntity;
    using TRideInspectionInfoEntity = TRideInfoEntity;
    using TRideDrivingInfoEntity = TRideInfoEntity;
    using TRideParkingInfoEntity = TRideInfoEntity;
    
    struct TRideSummaryInfoEntity {
        TDuration TotalDuration;
        i32 TotalPrice = 0;
    };

    struct TCarInsurancePolicyEntity {
        TString Description;
    };

    struct TOfferRangePriceEntity {
        i32 Min = 0;
        i32 Max = 0;
    };

    struct TOfferRangeEntity {
        TString Id;
        TString Name;
        TString Description;
        TCarInsurancePolicyEntity InsurancePolicy;
        TString PrePaymentInformation;
        i32 UsagePrice = 0;
        i32 HoldAmount = 0;
        TDuration FreeWaitingTime;
        TOfferRangePriceEntity Waiting;
        TOfferRangePriceEntity Parking;
        TOfferRangePriceEntity Riding;
        TOfferRangePriceEntity Inspection;
        TDuration FreeInspectionTime;
        TInstant ValidUntil;
    };

    struct TRideEntity {
        TString Id;
        TString DeepLink;
        TString SpecialMessage;
        TRideCarEntity Car;
        TOfferRangeEntity Offer;
        TRideWaitingInfoEntity WaitingInfo;
        TRideInspectionInfoEntity InspectionInfo;
        TRideDrivingInfoEntity DrivingInfo;
        TRideParkingInfoEntity ParkingInfo;
        TRideSummaryInfoEntity SummaryInfo;
        TLocationEntity PointStart;
        TLocationEntity PointFinish;
        TInstant CreatedAt;
        TInstant StartedAt;
        TInstant FinishedAt;
        TInstant CanceledAt;
        TString Status;
    };

    using TRideActiveEntity = TRideEntity;
    using TRideCreatedEntity = TRideEntity;

    // Report for "/ride".
    struct TActiveRideInfoEntity {
        TString Status;
        TRideActiveEntity Ride;
        TString DeepLink;
    };

    struct TZoneEntity {
        NGeoJson::TFeatureCollection GeoJson;
        TString Name;
        TString MapLabel;
        TString Description;
        TString ShortDescription;
    };

    struct TZoneSetEntity {
        NGeoJson::TFeatureCollection AvailableForDriving;
        TVector<TZoneEntity> ForbiddenComplete;
        TVector<TZoneEntity> AllowComplete;
    };

    struct TCarZoneSetEntity {
        TString Id;
        TInstant UpdatedAt;
    };

    struct TCarZonesEntity {
        NGeoJson::TFeatureCollection AvailableForDriving;
        TVector<TZoneEntity> ForbiddenComplete;
        TVector<TZoneEntity> AllowComplete;
        TVector<TCarZoneSetEntity> Sets;
    };

    struct TCarEntity {
        TString Id;
        TString DeepLink;
        TString Number;
        TFuelCapacity FuelCapacity;
        TLocationEntity Location;
        TString Model;
        TCarZonesEntity Zones;
        TVector<TOfferRangeEntity> Offers;
        TString ForbiddenRentReason;
        TString ForbiddenRentReasonMessage;
    };

    struct TPolicyEntity {
        TString Content;
        TString Version;
    };

    struct TRideCancelConfirmEntity {
        TString Id;
        TString Message;
    };

}
