#include <library/cpp/testing/unittest/registar.h>

#include <drive/library/cpp/mux/router.h>

Y_UNIT_TEST_SUITE(HttpRouter) {
    Y_UNIT_TEST(SimpleTest) {
        NDrive::THttpRouter<TString> router;
        router.Add("/api/object/:id", "GET", "object");
        router.Add("/api/object/:id/edit", "POST", "edit_object");
        router.Add("/api/object/:id/events", "GET", "object_events");
        router.Add("/api", "GET", "index");
        router.Add("/api/ping", "GET", "ping");
        NDrive::THttpRouter<TString>::TMatch match;
        UNIT_ASSERT(router.Match(match, "/api/object/123", "GET"));
        UNIT_ASSERT_EQUAL(match.Handler, "object");
        UNIT_ASSERT_EQUAL(match.Vars, (TMap<TString, TString>{{"id", "123"}}));
        UNIT_ASSERT(router.Match(match, "/api/object/:id", "GET"));
        UNIT_ASSERT_EQUAL(match.Handler, "object");
        UNIT_ASSERT_EQUAL(match.Vars, (TMap<TString, TString>{{"id", ":id"}}));
        UNIT_ASSERT(router.Match(match, "/api/object/", "GET"));
        UNIT_ASSERT_EQUAL(match.Handler, "object");
        UNIT_ASSERT_EQUAL(match.Vars, (TMap<TString, TString>{{"id", ""}}));
        UNIT_ASSERT(!router.Match(match, "/api/object/123", "POST"));
        UNIT_ASSERT(router.Match(match, "/api", "GET"));
        UNIT_ASSERT_EQUAL(match.Handler, "index");
        UNIT_ASSERT_EQUAL(match.Vars, (TMap<TString, TString>{}));
        UNIT_ASSERT(router.Match(match, "/api/object/123/events", "GET"));
        UNIT_ASSERT_EQUAL(match.Handler, "object_events");
        UNIT_ASSERT_EQUAL(match.Vars, (TMap<TString, TString>{{"id", "123"}}));
        UNIT_ASSERT(!router.Match(match, "/api/objects/123/events", "GET"));
        UNIT_ASSERT(router.Match(match, "/api/object/events/events", "GET"));
        UNIT_ASSERT_EQUAL(match.Handler, "object_events");
        UNIT_ASSERT_EQUAL(match.Vars, (TMap<TString, TString>{{"id", "events"}}));
        UNIT_ASSERT(router.Match(match, "/api/ping", "GET"));
        UNIT_ASSERT_EQUAL(match.Handler, "ping");
        UNIT_ASSERT_EQUAL(match.Vars, (TMap<TString, TString>{}));
        UNIT_ASSERT(router.Match(match, "/api/object/1/edit", "POST"));
        UNIT_ASSERT_EQUAL(match.Handler, "edit_object");
        UNIT_ASSERT_EQUAL(match.Vars, (TMap<TString, TString>{{"id", "1"}}));
    }
}
