#include "data.h"

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(NetworkData) {
    Y_UNIT_TEST(ParseReqId) {
        {
            auto reqId = "1614341128364946-15346197730450688876-man1-8457-man-rtline-drive-fronte-bc0-23635-YD";
            auto parsed = NUtil::ParseReqId(reqId);
            UNIT_ASSERT_VALUES_EQUAL(parsed.Timestamp, "1614341128364946");
            UNIT_ASSERT_VALUES_EQUAL(parsed.Rnd, "15346197730450688876");
        }
        {
            auto reqId = "1614341128364946";
            auto parsed = NUtil::ParseReqId(reqId);
            UNIT_ASSERT_VALUES_EQUAL(parsed.Timestamp, "1614341128364946");
            UNIT_ASSERT(parsed.Rnd.empty());
        }
    }
}
