#pragma once

#include "config.h"

#include <rtline/library/deprecated/async_impl/async_impl.h>

namespace NRobotPhoneCall {
    enum ECallStatus: ui32{
        InProgress = 0 /* "in_progress" */,
        OK = 1 /* "ok" */,
        Unanswer = 2 /* "unanswer" */,
        Error = 3 /* "error" */,
    };
};

class IOctopusClient {
public:
    virtual bool Call(const TString& phoneNumber, const TString& helloPrompt, const TString& goodbyePrompt, TString& sessionId) const = 0;

    virtual NRobotPhoneCall::ECallStatus GetCallStatus(const TString& sessionId) const = 0;

    virtual ~IOctopusClient() = default;
};

class TOctopusClient : public IOctopusClient {
    TOctopusClientConfig Config;
    TAtomicSharedPtr<TAsyncDelivery> AD;
    THolder<NNeh::THttpClient> Agent;

public:
    TOctopusClient(const TOctopusClientConfig& config)
        : Config(config)
        , AD(new TAsyncDelivery())
        , Agent(new NNeh::THttpClient(AD))
    {
        AD->Start(Config.GetRequestConfig().GetThreadsStatusChecker(), Config.GetRequestConfig().GetThreadsSenders());
        Agent->RegisterSource("octopus", Config.GetHost(), Config.GetPort(), Config.GetRequestConfig(), true);
    }

    virtual bool Call(const TString& phoneNumber, const TString& helloPrompt, const TString& goodbyePrompt, TString& sessionId) const override;

    virtual NRobotPhoneCall::ECallStatus GetCallStatus(const TString& sessionId) const override;
};

class TFakeOctopusClient : public IOctopusClient {
    mutable TVector<NRobotPhoneCall::ECallStatus> Responses;
    mutable size_t CurrentResponseIndex;
    mutable TMutex Mutex;

public:
    TFakeOctopusClient(const TVector<NRobotPhoneCall::ECallStatus>& responses)
        : Responses(responses)
        , CurrentResponseIndex(0)
    {
    }

    virtual bool Call(const TString& phoneNumber, const TString& helloPrompt, const TString& goodbyePrompt, TString& sessionId) const override;

    virtual NRobotPhoneCall::ECallStatus GetCallStatus(const TString& sessionId) const override;
};
