#include "config.h"

void TOctopusClientConfig::Init(const TYandexConfig::Section* section) {
    Token = section->GetDirectives().Value<TString>("Token", Token);
    if (!Token) {
        TString tokenPath;
        tokenPath = section->GetDirectives().Value<TString>("TokenPath", tokenPath);
        Token = Strip(TFileInput(tokenPath).ReadAll());
    }

    Host = section->GetDirectives().Value<TString>("Host", Host);
    Port = section->GetDirectives().Value<ui32>("Port", Port);
    RequestTimeout = section->GetDirectives().Value<TDuration>("RequestTimeout", RequestTimeout);

    CallURI = section->GetDirectives().Value<TString>("CallURI", CallURI);
    CallStatusURI = section->GetDirectives().Value<TString>("CallStatusURI", CallStatusURI);

    const TYandexConfig::TSectionsMap children = section->GetAllChildren();
    {
        auto it = children.find("RequestConfig");
        if (it != children.end()) {
            RequestConfig.InitFromSection(it->second);
        }
    }
    RequestConfig.SetMaxAttempts(1);

    TString callScriptPath;
    callScriptPath = section->GetDirectives().Value<TString>("CallScriptPath", callScriptPath);
    CHECK_WITH_LOG(callScriptPath);
    TFileInput in(callScriptPath);
    ReadJsonTree(&in, &CallScript);
    CHECK_WITH_LOG(CallScript != NJson::JSON_NULL);
}

void TOctopusClientConfig::ToString(IOutputStream& os) const {
    os << "Host: " << Host << Endl;
    os << "Port: " << Port << Endl;
    os << "RequestTimeout: " << RequestTimeout << Endl;
    os << "CallURI: " << CallURI << Endl;
    os << "CallStatusURI: " << CallStatusURI << Endl;
    os << "<RequestConfig>" << Endl;
    RequestConfig.ToString(os);
    os << "</RequestConfig>" << Endl;
}
