#pragma once

#include <kernel/daemon/config/daemon_config.h>

#include <library/cpp/json/json_reader.h>
#include <library/cpp/logger/global/global.h>
#include <library/cpp/mediator/global_notifications/system_status.h>
#include <library/cpp/string_utils/url/url.h>

#include <rtline/library/deprecated/async_impl/async_impl.h>
#include <rtline/util/types/accessor.h>

#include <util/stream/file.h>


class TOctopusClientConfig {
    R_READONLY(TString, Host);
    R_READONLY(ui32, Port, 0);
    R_READONLY(TString, Token);
    R_READONLY(TDuration, RequestTimeout, TDuration::Seconds(1));

    R_READONLY(TString, CallStatusURI, "api/session_log/query");
    R_READONLY(TString, CallURI, "api/session/create");

    R_READONLY(NJson::TJsonValue, CallScript);
    R_READONLY(NSimpleMeta::TConfig, RequestConfig);

public:
    void Init(const TYandexConfig::Section* section);

    void ToString(IOutputStream& os) const;
};
