#pragma once

#include <rtline/util/types/accessor.h>

#include <kernel/daemon/config/daemon_config.h>

#include <library/cpp/mediator/global_notifications/system_status.h>
#include <library/cpp/object_factory/object_factory.h>

#include <util/stream/file.h>
#include <util/string/hex.h>
#include <util/string/type.h>

class TBlob;

namespace NOpenssl {
    enum class ECipherType: ui32 {
        AES = 0 /* "aes" */,
    };

    class TCipherConfig {
        R_FIELD(ECipherType, Type, ECipherType::AES);
        R_FIELD(TString, KeyPath);
        R_FIELD(TString, Key);

    public:
        void Init(const TYandexConfig::Section* section) {
            {
                TString typeStr;
                typeStr = section->GetDirectives().Value<TString>("Type", typeStr);
                AssertCorrectConfig(TryFromString(typeStr, Type), typeStr + " is not ECipherType enum element");
            }
            {
                KeyPath = section->GetDirectives().Value<TString>("KeyPath", KeyPath);
                if (KeyPath) {
                    Key = HexDecode(Strip(TFileInput(KeyPath).ReadAll()));
                }
            }
            if (!Key) {
                Key = HexDecode(section->GetDirectives().Value<TString>("Key", Key));
            }
        }

        void ToString(IOutputStream& os) const {
            os << "Type: " << ::ToString(Type) << Endl;
            os << "KeyPath: " << KeyPath << Endl;
        }
    };

    class IAbstractCipher {
    public:
        using TPtr = THolder<IAbstractCipher>;
        using TFactory = NObjectFactory::TParametrizedObjectFactory<IAbstractCipher, ECipherType>;

        virtual ~IAbstractCipher() = default;

        virtual void Init(const TCipherConfig& config) = 0;

        virtual bool Encrypt(const TString& plain, TString& encrypted) const = 0;
        virtual bool Decrypt(const TString& encrypted, TString& result) const = 0;
    };
};
