#include "oio.h"

#include <library/cpp/openssl/init/init.h>
#include <library/cpp/testing/unittest/env.h>
#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(OpenSSLTestSuite) {
    Y_UNIT_TEST(PEM_PKCS7) {
        InitOpenSSL();
        TString data = "42";

        auto certificate = NOpenssl::GetCertificateFromFile(BinaryPath("contrib/python/Scrapy/tests/keys/example-com.cert.pem"));
        UNIT_ASSERT(certificate);

        auto key = NOpenssl::GetPrivateKeyFromFile(BinaryPath("contrib/python/Scrapy/tests/keys/example-com.key.pem"));
        UNIT_ASSERT(key);

        auto package = NOpenssl::FormSignedPackage(data, certificate, key);
        UNIT_ASSERT(package);

        TString pkcs7 = NOpenssl::PrintPEM(package, data);
        UNIT_ASSERT(pkcs7);

        auto package2 = NOpenssl::ReadSignedData(pkcs7);
        UNIT_ASSERT(package2);

        TStringBuf data2 = NOpenssl::GetData(package2);
        UNIT_ASSERT_VALUES_EQUAL(data, data2);
    }

    Y_UNIT_TEST(PEM_CMS) {
        InitOpenSSL();
        TString data = "42";

        auto certificate = NOpenssl::GetCertificateFromFile(BinaryPath("contrib/python/Scrapy/tests/keys/example-com.cert.pem"));
        UNIT_ASSERT(certificate);

        auto key = NOpenssl::GetPrivateKeyFromFile(BinaryPath("contrib/python/Scrapy/tests/keys/example-com.key.pem"));
        UNIT_ASSERT(key);

        auto package = NOpenssl::FormSignedCMS(data, certificate, key);
        UNIT_ASSERT(package);

        TString pkcs7 = NOpenssl::PrintPEM(package, data);
        UNIT_ASSERT(pkcs7);

        auto package2 = NOpenssl::ReadSignedCMS(pkcs7);
        UNIT_ASSERT(package2);

        TStringBuf data2 = NOpenssl::GetData(package2);
        UNIT_ASSERT_VALUES_EQUAL(data, data2);
    }
}
