#pragma once

#include <rtline/api/graph/router/router.h>
#include <drive/library/cpp/parking/api/client.h>

namespace NDrive {
    class TParkingListClient {
    public:
        static constexpr i64 KznAggregatorId = 10016;
        static constexpr i64 MskAggregatorId = 2;
        static constexpr i64 SpbAggregatorId = 10772;

        static constexpr i64 AmppAggregatorId = 3;
        static constexpr i64 FitDevMskParkingId = 4;

    public:
        using TParking = TParkingPaymentClient3::TParking;
        using TParkings = TParkingPaymentClient3::TParkings;

    public:
        template <class... TArgs>
        TParkingListClient(TArgs&&... args)
            : Router(std::forward<TArgs>(args)...)
        {
        }

        NThreading::TFuture<TParkings> GetParkings(double latitude, double longitude, double searchRadius = 250) const;

    private:
        NGraph::TRouter Router;
    };
}
