#include "client.h"

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(InhouseParkingListClientSuite) {
    Y_UNIT_TEST(AggregatorId) {
        NRTLine::TNehSearchClient searchClient("drive_router", "saas-searchproxy-maps.yandex.net", 17000);
        NDrive::TParkingListClient client(searchClient);

        auto mskParkings = client.GetParkings(55.733723, 37.589789).ExtractValueSync();
        UNIT_ASSERT(!mskParkings.empty());
        for (auto&& parking : mskParkings) {
            UNIT_ASSERT_VALUES_EQUAL(parking.AggregatorId, NDrive::TParkingListClient::MskAggregatorId);
        }

        auto kznParkings = client.GetParkings(55.794355, 49.117142).ExtractValueSync();
        UNIT_ASSERT(!kznParkings.empty());
        for (auto&& parking : kznParkings) {
            UNIT_ASSERT_VALUES_EQUAL(parking.AggregatorId, NDrive::TParkingListClient::KznAggregatorId);
        }
    }
}
