#pragma once

#include <library/cpp/tvmauth/client/facade.h>

#include <rtline/library/deprecated/async_impl/async_impl.h>

/*
Docs: https://wiki.yandex-team.ru/passport/api/bundle/auth/Probros-avtorizacii-v-golovnoe-ustrojjstvo-Drajjva/#nachalopoezdki
*/

class TPassportClientConfig : public TSimpleAsyncRequestSender::TConfig {
private:
    R_READONLY(TString, RequestPolicyName);
    R_READONLY(TString, StartApiPath, "/1/bundle/auth/forward_drive/start/");
    R_READONLY(TString, StopApiPath, "/1/bundle/auth/forward_drive/stop/");
    R_READONLY(TDuration, RequestTimeout, TDuration::Seconds(1));
    R_READONLY(ui32, Threads, 1);
    R_READONLY(ui32, SelfClientId, 0);
    R_READONLY(ui32, DestinationClientId, 0);
    R_READONLY(TString, Consumer, "y.drive-sessions");

public:
    TPassportClientConfig() = default;

    void Init(const TYandexConfig::Section* section, const TMap<TString, NSimpleMeta::TConfig>* requestPolicy);
    void ToString(IOutputStream& os) const;

    static TPassportClientConfig ParseFromString(const TString& configStr) {
        TPassportClientConfig result;
        TAnyYandexConfig config;
        CHECK_WITH_LOG(config.ParseMemory(configStr.data()));
        result.Init(config.GetRootSection(), nullptr);
        return result;
    }
};

class TPassportClient {
private:
    using TGuard = NNeh::THttpClient::TGuard;
    class TCallback;

public:
    TPassportClient(const TPassportClientConfig& config, TAtomicSharedPtr<NTvmAuth::TTvmClient> tvmCLient)
        : Config(config)
        , Impl(Config, "passport_api")
        , Tvm(tvmCLient)
    {
        CHECK_WITH_LOG(Tvm);
        RepliesHandler.Start(Config.GetThreads());
    }

    NThreading::TFuture<void> StartSessionAsync(const TString& userTicket, const TString& clientIp, const TString& sessionId, const TString& deviceId) const;
    NThreading::TFuture<void> StopSessionAsync(const TString& userTicket, const TString& clientIp, const TString& sessionId, const TString& deviceId) const;

private:
    NNeh::THttpRequest CreateRequest(const TString& userTicket, const TString& clientIp, const TString& postData = TString()) const;

private:
    TPassportClientConfig Config;
    TSimpleAsyncRequestSender Impl;
    TAtomicSharedPtr<NTvmAuth::TTvmClient> Tvm;
    mutable TThreadPool RepliesHandler;
};
