#pragma once

#include "config.h"


namespace NDrive::NRedis {

    class TClient {
    public:
        TClient(const TConfig& config);
        const TConfig& GetConfig() const;

        NThreading::TFuture<TString> Get(const TString& key) const;
        NThreading::TFuture<TString> Set(const TString& key, const TString& value, const TDuration ttl = TDuration::Zero()) const;
        NThreading::TFuture<bool> Del(const TString& key) const;

    private:
        TConfig Config;
        TAtomicSharedPtr<NNeh::THttpClient> Client;
    };
}
