#include "config.h"

#include <library/cpp/mediator/global_notifications/system_status.h>

#include <util/folder/path.h>
#include <util/stream/file.h>


bool NDrive::NRedis::TConfig::Init(const TYandexConfig::Section* section) {
    Uri = section->GetDirectives().Value("Uri", Uri);
    AssertCorrectConfig(!!Uri, "host is not defined");
    UriPath = section->GetDirectives().Value("UriPath", UriPath);
    {
        const TYandexConfig::TSectionsMap children = section->GetAllChildren();
        auto it = children.find("RequestConfig");
        if (it != children.end()) {
            RequestConfig.InitFromSection(it->second);
        }
    }
    RequestTimeout  = section->GetDirectives().Value("RequestTimeout", RequestTimeout);
    return true;
}

void NDrive::NRedis::TConfig::ToString(IOutputStream& os) const {
    os << "Uri: " << Uri << Endl;
    if (UriPath) {
        os << "UriPath: " << UriPath << Endl;
    }
    os << "<RequestConfig>" << Endl;
    RequestConfig.ToString(os);
    os << "</RequestConfig>" << Endl;
    os << "RequestTimeout: " << RequestTimeout << Endl;
}

TAtomicSharedPtr<NDrive::NRedis::TConfig> NDrive::NRedis::TConfig::ParseFromString(const TString& configStr) {
    TAnyYandexConfig config;
    if (!config.ParseMemory(configStr.data())) {
        ERROR_LOG << "Fail to parse config:" + configStr << Endl;
        return nullptr;
    }
    auto result = MakeAtomicShared<TConfig>();
    if (!result->Init(config.GetRootSection())) {
        return nullptr;
    }
    return result;
}
