#pragma once

#include <rtline/util/network/neh.h>
#include <rtline/util/types/accessor.h>

#include <kernel/daemon/config/daemon_config.h>

namespace NDrive::NRedis {

    class TConfig {
    public:
        bool Init(const TYandexConfig::Section* section);
        void ToString(IOutputStream& os) const;
        static TAtomicSharedPtr<TConfig> ParseFromString(const TString& configStr);

    private:
        R_READONLY(TString, Uri);
        R_READONLY(TString, UriPath);
        R_READONLY(NSimpleMeta::TConfig, RequestConfig);
        R_READONLY(TDuration, RequestTimeout, TDuration::MilliSeconds(100));
    };

}
