#pragma once

#include "config.h"
#include "entities.h"


namespace NDrive::NRenins {
    class TKaskoException: public yexception {
    private:
        const TString Code;
        const TString Message;

    public:
        TKaskoException(const TString& code, const TString& message)
            : Code(code)
            , Message(message)
        {}

        TString GetCode() const {
            return Code;
        }

        TString GetMessage() const {
            return Message;
        }
    };

    class TInsuranceClient {
    public:
        TInsuranceClient(const TReninsConfig& config);
        const TReninsConfig& GetConfig() const;

    protected:
        NThreading::TFuture<NUtil::THttpReply> Calculate(const NJson::TJsonValue& context) const;
        NThreading::TFuture<NUtil::THttpReply> Order(const TString& orderId, const NJson::TJsonValue& context) const;
        NThreading::TFuture<NUtil::THttpReply> GetStatus(const TString& orderId) const;
        NThreading::TFuture<NUtil::THttpReply> GetPaymentLink(const TMainOrderData& orderData) const;
        NThreading::TFuture<NUtil::THttpReply> GetDocument(const TString& orderId, const TString& dealId) const;

    private:
        TReninsConfig Config;
        TAtomicSharedPtr<NNeh::THttpClient> Client;
    };

    class TInsuranceSyncClient {
    public:
        TInsuranceSyncClient(const TReninsConfig& config);
        const TReninsConfig& GetConfig() const;

    protected:
        NThreading::TFuture<NUtil::THttpReply> Calculate(const NJson::TJsonValue& context) const;
        NThreading::TFuture<NUtil::THttpReply> Order(const TString& orderId, const NJson::TJsonValue& context) const;
        NThreading::TFuture<NUtil::THttpReply> GetStatus(const TString& orderId) const;
        NThreading::TFuture<NUtil::THttpReply> GetPaymentLink(const TMainOrderData& orderData) const;
        NThreading::TFuture<NUtil::THttpReply> GetDocument(const TString& orderId, const TString& dealId) const;
        NThreading::TFuture<NUtil::THttpReply> GetAutocodeData(const TString& carNumber) const;

    private:
        TReninsConfig Config;

        R_FIELD(TString, Host);
        R_FIELD(ui16, Port, 80);
        R_FIELD(bool, Https, false);
    };

    namespace NOsago {
        class TClient : public TInsuranceClient {
        public:
            using TBase = TInsuranceClient;

        public:
            using TBase::TBase;
            NThreading::TFuture<TCalculateOrderResult> Calculate(const TCalculateOrder& context) const;
        };
    }

    namespace NKasko {
        class TClient : public TInsuranceSyncClient {
        public:
            using TBase = TInsuranceSyncClient;

        public:
            using TBase::TBase;
            NThreading::TFuture<TCalculateOrderResult> Calculate(const TCalculateOrder& context, const TString& requiredPack) const;
            NThreading::TFuture<TOrderStatus> Order(const TStartOrderData& context) const;
            NThreading::TFuture<TOrderStatus> GetStatus(const TString& orderId) const;
            NThreading::TFuture<TString> GetPaymentLink(const TMainOrderData& orderData) const;
            NThreading::TFuture<TString> GetDocument(const TString& orderId, const TString& dealId) const;
            NThreading::TFuture<TAutocodeCarData> GetAutocodeData(const TString& carNumber) const;
        };
    }
}
