#include "config.h"

#include <library/cpp/mediator/global_notifications/system_status.h>

#include <util/folder/path.h>
#include <util/stream/file.h>


namespace NDrive::NRenins {

    bool TReninsConfig::Init(const TYandexConfig::Section* section) {
        Uri = section->GetDirectives().Value("Uri", Uri);
        UriPath = section->GetDirectives().Value("UriPath", UriPath);
        TokenTimeout = section->GetDirectives().Value("TokenTimeout", TokenTimeout);
        Token = section->GetDirectives().Value("Token", Token);
        TokenPath = section->GetDirectives().Value("TokenPath", TokenPath);
        AssertCorrectConfig(Token || TokenPath, "neither token nor token path are defined");
        if (!Token) {
            AssertCorrectConfig(TFsPath(TokenPath).Exists(), "Incorrect path for tanker's apikey in 'TokenPath'");
            TFileInput fi(TokenPath);
            Token = fi.ReadAll();
        }
        {
            const TYandexConfig::TSectionsMap children = section->GetAllChildren();
            auto it = children.find("RequestConfig");
            if (it != children.end()) {
                RequestConfig.InitFromSection(it->second);
            }
        }
        RequestTimeout  = section->GetDirectives().Value("RequestTimeout", RequestTimeout);
        return true;
    }

    void TReninsConfig::ToString(IOutputStream& os) const {
        os << "Uri: " << Uri << Endl;
        os << "UriPath: " << UriPath << Endl;
        os << "TokenTimeout: " << TokenTimeout << Endl;
        if (TokenPath) {
            os << "TokenPath: " << TokenPath << Endl;
        }
        os << "<RequestConfig>" << Endl;
        RequestConfig.ToString(os);
        os << "</RequestConfig>" << Endl;
        os << "RequestTimeout: " << RequestTimeout << Endl;
    }

    void TReninsConfig::Authorize(NNeh::THttpRequest& request) const {
        request.AddHeader("Authorization", "Bearer " + Token);
    }

    TAtomicSharedPtr<TReninsConfig> TReninsConfig::ParseFromString(const TString& configStr) {
        TAnyYandexConfig config;
        if (!config.ParseMemory(configStr.data())) {
            ERROR_LOG << "Fail to parse config:" + configStr << Endl;
            return nullptr;
        }
        auto result = MakeAtomicShared<TReninsConfig>();
        if (!result->Init(config.GetRootSection())) {
            return nullptr;
        }
        return result;
    }

}
