#pragma once

#include <rtline/util/network/neh.h>
#include <rtline/util/types/accessor.h>

#include <kernel/daemon/config/daemon_config.h>

namespace NDrive::NRenins {

    class TReninsConfig {
    public:
        bool Init(const TYandexConfig::Section* section);
        void ToString(IOutputStream& os) const;
        void Authorize(NNeh::THttpRequest& request) const;
        static TAtomicSharedPtr<TReninsConfig> ParseFromString(const TString& configStr);

    private:
        R_READONLY(TString, Uri, "https://apigateway.renins.com");
        R_READONLY(TString, UriPath, "link2api/eOsagoInsurance/1.0");
        R_READONLY(TString, Token);
        R_READONLY(TString, TokenPath);
        R_READONLY(TDuration, TokenTimeout, TDuration::Hours(1));
        R_READONLY(NSimpleMeta::TConfig, RequestConfig);
        R_READONLY(TDuration, RequestTimeout, TDuration::Minutes(1));
    };

}
