#include "reqid.h"

#include <kernel/reqid/reqid.h>

#include <library/cpp/http/misc/httpreqdata.h>

namespace {
    const TString ReqIdParameter = "reqid";
    const TString ReqIdClass = "SAAS";
}

void NDrive::FormReqId(TCgiParameters& cgi, const TBaseServerRequestData* rd, TStringBuf reqIdClass) {
    if (!cgi.Has(ReqIdParameter)) {
        TString reqId;
        if (!reqIdClass) {
            reqIdClass = ReqIdClass;
        }
        const TString* externalReqId = rd ? rd->HeaderIn("X-Req-Id") : nullptr;
        if (externalReqId) {
            reqId = *externalReqId + "-" + ReqIdHostSuffix() + "-" + reqIdClass;
        } else {
            reqId = ReqIdGenerate(reqIdClass.data());
        }
        cgi.InsertUnescaped(ReqIdParameter, reqId);
    }
}
