#pragma once

#include <rtline/util/network/neh.h>

namespace NDrive {

    struct TRtmrSurge {
        double Prediction;
        TVector<float> FloatFeatures;
    };

    struct TRtmrExtendedSurge {
        TVector<float> FloatFeatures;
        THashMap<TString, double> Predictions60min;
        THashMap<TString, double> Predictions120min;
        THashMap<TString, double> Predictions180min;
    };

    class TRtmrSurgeClient {
    public:
        struct TOptions {
            TString Endpoint = "http://rtmr.search.yandex.net:8080/";
            TString Client = "yandexcarsharing";
            TDuration Timeout = TDuration::MilliSeconds(300);
            size_t MaxSubkeys = 1000;

            TString Path = "drive/surge/result";
            TString ExtendedPath = "drive/surge/result_extended";
        };

        TRtmrSurgeClient(TOptions options = Default<TOptions>());

        // GetSurge returns surge for specified key.
        NThreading::TFuture<TMaybe<TRtmrSurge>> GetSurge(const TString& key) const;

        // GetExtendedSurge returns extended surge for specified key.
        NThreading::TFuture<TMaybe<TRtmrExtendedSurge>> GetExtendedSurge(const TString& key) const;
    
    protected:
        // GetTableValue returns value from RTMR table.
        NThreading::TFuture<NJson::TJsonValue> GetTableValue(const TString& path, const TString& key, int maxRecords = 1000) const;

    private:
        THolder<NNeh::THttpClient> Client;
        TOptions Options;
    };

    // GetRtmrAreaKey returns key in surge table for specified area.
    TString GetRtmrAreaKey(const TString& name);

}
