#pragma once

#include "config.h"
#include "entity.h"
#include "logger.h"

#include <rtline/library/deprecated/async_impl/client.h>
#include <rtline/util/json_processing.h>

#include <util/string/builder.h>

class TSamsaraClient : public TRequestClient<TSamsaraClientConfig, TSamsaraLogger> {
    using TBase = TRequestClient<TSamsaraClientConfig, TSamsaraLogger>;

public:
    using TArticle = TSamsaraArticle;
    using TTicket = TSamsaraTicket;

    class TTicketUpdateInfo {
        R_READONLY(ui64, TicketId, 0);
        R_READONLY(ui64, ArticleId, 0);

    public:
        bool DeserializeFromJson(const NJson::TJsonValue& data) {
            JREAD_UINT(data, "ticketId", TicketId);
            JREAD_UINT_NULLABLE_OPT(data, "articleId", ArticleId);
            return true;
        }
    };

    TSamsaraClient(const TSamsaraClientConfig& config)
        : TBase(config, "samsara-api")
    {
    }

    bool GetQueues(TVector<TSamsaraQueue>& results, TMessagesCollector& errors, const TSamsaraQueue::TId& queueId = TSamsaraQueue::UndefinedQueueId) const;
    bool GetNestedQueueIds(const TSamsaraQueue::TId& rootQueueId, TVector<TSamsaraQueue::TId>& results, TMessagesCollector& errors) const;

    bool QueryUpdatedTickets(const TSamsaraQueue::TId& queueId, const TInstant& minTs, const TInstant& maxTs, TVector<TTicketUpdateInfo>& results, TMessagesCollector& errors) const;
    bool GetTicket(const TTicket::TId& ticketId, TSamsaraTicket& result, TMessagesCollector& errors) const;
    bool GetMultipleTickets(const TVector<TTicket::TId>& ticketIds, TVector<TSamsaraTicket>& results, TMessagesCollector& errors) const;

private:
    NNeh::THttpRequest CreateGetQueuesRequest(const TSamsaraQueue::TId& queueId = TSamsaraQueue::UndefinedQueueId) const;
    NNeh::THttpRequest CreateGetTicketRequest(const TTicket::TId& ticketId) const;
    NNeh::THttpRequest CreateGetMultipleTicketsRequest(const TVector<TTicket::TId>& ticketIds) const;
    NNeh::THttpRequest CreateQueryUpdatedTicketsRequest(const TSamsaraQueue::TId& queueId, const TInstant& minTs, const TInstant& maxTs) const;
};
