#pragma once

#include <rtline/util/json_processing.h>
#include <rtline/util/types/accessor.h>

#include <util/generic/map.h>

class TSamsaraQueue {
public:
    using TId = ui64;

    static const TId UndefinedQueueId;

    R_READONLY(TId, Id, UndefinedQueueId);
    R_READONLY(TId, ParentQueueId, UndefinedQueueId);
    R_READONLY(TString, Name);
    R_READONLY(TString, State);
    R_READONLY(ui64, OpenTicketsCount, 0);

public:
    bool DeserializeFromJson(const NJson::TJsonValue& data);
};

class TSamsaraTag {
public:
    using TId = ui64;

    static const TId UndefinedTagId;

    R_READONLY(TId, Id, UndefinedTagId);
    R_READONLY(TId, ParentTagId, UndefinedTagId);
    R_READONLY(TString, Name);
    R_READONLY(TString, State);

public:
    bool DeserializeFromJson(const NJson::TJsonValue& data);
};

class TSamsaraArticleRecepient {
    R_READONLY(TString, Login);
    R_READONLY(TString, Name);
    R_READONLY(TString, Email);

public:
    bool DeserializeFromJson(const NJson::TJsonValue& data);
};

class TSamsaraArticleAttachment {
    R_READONLY(TString, Name);
    R_READONLY(TString, ContentType);
    R_READONLY(i64, Size, 0);
    R_READONLY(TString, Uri);
    R_READONLY(TString, ExternalId);
    R_READONLY(TString, Type);       // either "USER" or "MESSAGE_SOURCE"


public:
    bool DeserializeFromJson(const NJson::TJsonValue& data);
};

class TSamsaraArticleBodyPart {
public:
    using TCustomData = TMap<TString, TString>;

    R_READONLY(TString, Type);       // one of CHAT_IN, CHAT_OUT, CHAT_NOTE, EMAIL_PART

    R_READONLY(TCustomData, CustomData);
    R_READONLY(TString, Content);
    R_READONLY(TString, ContentType);

public:
    bool DeserializeFromJson(const NJson::TJsonValue& data);
};

class TSamsaraArticle {
public:
    using TId = ui64;

    using TTag = TSamsaraTag;
    using TTags = TVector<TTag>;

    using TRecepient = TSamsaraArticleRecepient;
    using TRecepients = TVector<TSamsaraArticleRecepient>;

    using TAttachment = TSamsaraArticleAttachment;
    using TAttachments = TVector<TAttachment>;

    using TCustomData = TMap<TString, TString>;

    using TBodyPart = TSamsaraArticleBodyPart;
    using TBodyParts = TVector<TBodyPart>;

    static const TId UndefinedArticleId;

    R_READONLY(TString, Type);
    R_READONLY(TId, Id, 0);
    R_READONLY(TId, ParentArticleId, 0);
    R_READONLY(TTags, Tags);
    R_READONLY(TVector<TString>, LinkedStartrekTickets);

    R_READONLY(TRecepient, From);
    R_READONLY(TRecepients, To);
    R_READONLY(TRecepients, Cc);
    R_READONLY(TRecepients, Bcc);
    R_READONLY(TRecepients, ReplyTo);

    R_READONLY(TInstant, CreatedTs);

    R_READONLY(TString, Subject);
    R_READONLY(TString, Body);

    R_READONLY(TAttachments, Attachments);

    R_READONLY(TCustomData, CustomData);

    R_READONLY(bool, MessageBodyTrimmed, false);

    R_READONLY(TBodyParts, BodyParts);

public:
    bool DeserializeFromJson(const NJson::TJsonValue& data);
};

class TSamsaraTicket {
public:
    using TArticle = TSamsaraArticle;
    using TArticles = TVector<TArticle>;

    using TTag = TSamsaraTag;
    using TTags = TVector<TTag>;

    using TId = TString;

    R_READONLY(TString, TicketNumber);
    R_READONLY(TString, Subject);

    R_READONLY(TString, Status);
    R_READONLY(TString, Resolution);
    R_READONLY(TString, Priority);

    R_READONLY(TArticles, Articles);

    R_READONLY(TInstant, CreatedTs);
    R_READONLY(TInstant, UpdatedTs, TInstant::Zero());
    R_READONLY(TInstant, OpenSinceTs, TInstant::Zero());
    R_READONLY(TInstant, ReopenTs, TInstant::Zero());

    R_READONLY(TTags, Tags);
    R_READONLY(TSamsaraQueue::TId, QueueId, 0);

    R_READONLY(TString, CreatedBy);
    R_READONLY(TString, CreatedFor);
    R_READONLY(TString, UpdatedBy);

    R_READONLY(TSamsaraArticle::TId, LastArticleId, 0);
    R_READONLY(TSamsaraArticle::TId, RootArticleId, 0);

    R_READONLY(TString, Channel);
    R_READONLY(TVector<TId>, LinkedTickets);

    R_READONLY(TId, Id);

public:
    bool DeserializeFromJson(const NJson::TJsonValue& data);
};
