#pragma once

#include <drive/library/cpp/auth/tvm.h>
#include <rtline/util/network/neh.h>

namespace NDrive {

    class TSaturnClient {
    public:
        struct TOptions {
            TString Endpoint = "https://saturn-testing.mlp.yandex.net";
            TDuration RequestTimeout = TDuration::Seconds(1);
        };

        struct TDebtScoringOptions {
            TString ReqId;
            ui64 PassportUid;
            TString FormulaId;
            TString Service;
            // Amount should contain total cost of offer in rub.
            TMaybe<double> Amount;
        };

        struct TResult {
            TString ReqId;
            ui64 PassportUid;
            float Score;
            float ScoreRaw;
            TString FormulaId;
            TString FormulaDescription;
            TString DataSource;
            TString Status;
        };

        TSaturnClient(const TOptions& options, TMaybe<TTvmAuth> tvmAuth);

        NThreading::TFuture<TResult> GetDebtScoring(const TDebtScoringOptions& options) const;

    private:
        THolder<NNeh::THttpClient> Client;
        TOptions Options;
        TMaybe<TTvmAuth> TvmAuth;
    };

}
