#include "config.h"

namespace NDrive {

    void TSaturnClientConfig::Init(const TYandexConfig::Section* section) {
        Y_ENSURE_BT(section);
        const auto& directives = section->GetDirectives();
        Options.Endpoint = directives.Value("Endpoint", Options.Endpoint);
        Options.RequestTimeout = directives.Value("RequestTimeout", Options.RequestTimeout);
        SelfClientId = directives.Value("SelfClientId", SelfClientId);
        DestinationTvmId = directives.Value("DestinationTvmId", DestinationTvmId);
    }

    void TSaturnClientConfig::ToString(IOutputStream& os) const {
        os << "Endpoint: " << Options.Endpoint << Endl;
        os << "RequestTimeout: " << Options.RequestTimeout << Endl;
        os << "SelfClientId: " << SelfClientId << Endl;
        os << "DestinationTvmId: " << DestinationTvmId << Endl;
    }

}
