#include <drive/library/cpp/saturn/client.h>
#include <drive/library/cpp/threading/future.h>
#include <drive/library/cpp/tvm/logger.h>

#include <library/cpp/testing/unittest/registar.h>

#include <rtline/library/json/cast.h>
#include <rtline/util/algorithm/ptr.h>

#include <util/system/env.h>

Y_UNIT_TEST_SUITE(SaturnClient) {
    Y_UNIT_TEST(Simple) {
        auto tvmIdString = GetEnv("TVM_ID", "2010062");
        Y_ENSURE(tvmIdString, "TVM_ID is undefined");
        auto tvmId = FromString<ui32>(tvmIdString);
        auto targetTvmIdString = GetEnv("TARGET_TVM_ID", "2028166");
        Y_ENSURE(targetTvmIdString, "TVM_ID is undefined");
        auto targetTvmId = FromString<ui32>(targetTvmIdString);
        auto tvmSecret = GetEnv("TVM_SECRET");
        Y_ENSURE(tvmSecret, "TVM_SECRET is undefined");
        auto passportUidString = GetEnv("PASSPORT_UID", "218638639");
        Y_ENSURE(passportUidString, "PASSPORT_UID is undefined");
        auto passportUid = FromString<ui64>(passportUidString);
        NDrive::TSaturnClient::TOptions options;
        NTvmAuth::NTvmApi::TClientSettings clientSettings;
        clientSettings.SetSelfTvmId(tvmId);
        clientSettings.EnableServiceTicketsFetchOptions(tvmSecret, {targetTvmId});
        auto tvm = MakeAtomicShared<NTvmAuth::TTvmClient>(clientSettings, CreateGlobalTvmLogger());
        NDrive::TTvmAuth tvmAuth(tvm, targetTvmId);
        NDrive::TSaturnClient client(options, tvmAuth);
        NDrive::TSaturnClient::TDebtScoringOptions scoringOptions;
        scoringOptions.Service = "drive";
        scoringOptions.PassportUid = passportUid;
        scoringOptions.Amount = 1024;
        auto scoringFuture = client.GetDebtScoring(scoringOptions);
        scoringFuture.Wait();
        UNIT_ASSERT_C(!scoringFuture.HasException(), NThreading::GetExceptionMessage(scoringFuture));
        UNIT_ASSERT(scoringFuture.HasValue());
        auto scoring = scoringFuture.GetValue();
        UNIT_ASSERT_EQUAL(scoring.PassportUid, scoringOptions.PassportUid);
        UNIT_ASSERT_EQUAL(scoring.Status, "accepted");
    }
}
