#include "sd.h"

NDrive::TSupplyDemandStat NDrive::TSupplyDemandHistory::Get(const TGeoCoord& coordinate, TDuration offset) {
    auto temporal = TBase::Get(coordinate);
    if (!temporal) {
        return {};
    }
    auto stat = temporal->Get(offset);
    if (!stat) {
        return {};
    }
    return *stat;
}

template <>
NJson::TJsonValue NJson::ToJson(const NDrive::TSupplyDemandStat& object) {
    NJson::TJsonValue result;
    result.AppendValue(object.Demand);
    result.AppendValue(object.Supply);
    return result;
}
