#pragma once

#include "geo.h"
#include "temporal.h"

namespace NDrive {
    struct TSupplyDemandStat {
        float Demand = 0;
        float Supply = 0;

        Y_SAVELOAD_DEFINE(
            Demand,
            Supply
        );
    };

    class TSupplyDemandHistory : protected TGeoSchedule<TTemporalSchedule<TSupplyDemandStat>> {
    public:
        using TBase = TGeoSchedule<TTemporalSchedule<TSupplyDemandStat>>;
        using TTemporal = TTemporalSchedule<TSupplyDemandStat>;

    public:
        using TBase::TBase;
        using TBase::Add;
        using TBase::Load;
        using TBase::Save;

        TSupplyDemandStat Get(const TGeoCoord& coordinate, TDuration offset);
    };
}
