#include "sd.h"

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/unittest/tests_data.h>

#include <util/stream/file.h>

Y_UNIT_TEST_SUITE(SupplyDemandSuite) {
    Y_UNIT_TEST(Simple) {
        auto path = TFsPath(GetWorkPath()) / "model.bin";
        TIFStream file(path);
        NDrive::TSupplyDemandHistory history;
        history.Load(&file);

        {
            auto coordinate = TGeoCoord(37.465340, 55.781154);
            auto offset = TDuration::Hours(8);
            auto stat = history.Get(coordinate, offset);
            Cerr << stat.Demand << '\t' << stat.Supply << Endl;
            UNIT_ASSERT(stat.Demand > 0);
            UNIT_ASSERT(stat.Supply > 0);
        }
    }
}
