#include "replier.h"

#include <drive/library/cpp/openssl/rsa.h>

#include <library/cpp/streams/lz/lz.h>

#include <rtline/library/unistat/signals.h>

#include <util/stream/buffer.h>
#include <util/stream/zlib.h>

namespace NRTLineHistogramSignals {
    const NUnistat::TIntervals TimeIntervals = { 0, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100, 110, 120, 130, 140, 150, 160, 170, 180, 190, 200, 300, 400, 500, 1000, 2000 };
}

std::atomic<ui64> IReplyContext::GlobalRequestsCounter = 0;
TUnistatSignal<ui64> TimeoutHistogramSignal({ "request-timeout", "request-timeout-CTYPE-SERV" }, NRTLineHistogramSignals::TimeIntervals);
TUnistatSignal<ui64> IncorrectTimeoutSignal({ "incorrect-request-timeout", "incorrect-request-timeout-CTYPE-SERV" }, false);
TUnistatSignal<ui64> NoTimeoutSignal({ "no-request-timeout", "no-request-timeout-CTYPE-SERV" }, false);

namespace {
    class TSignalQueueDuration: public TUnistatSignal<double> {
    public:
        TSignalQueueDuration()
            : TUnistatSignal<double>({"queue-duration-CTYPE-SERV", "queue-duration" }, NRTLineHistogramSignals::IntervalsRTLineReply)
        {
        }
    };

    static TSignalQueueDuration SignalQueueDuration;
}

EDeadlineCorrectionResult IReplyContext::DeadlineCorrection(const TDuration& scatterTimeout) {
    SignalQueueDuration.Signal((Now() - GetRequestStartTime()).MilliSeconds());
    TCgiParameters& cgi = MutableCgiParameters();
    TCgiParameters::iterator iter = cgi.find(TStringBuf("timeout"));
    if (iter == cgi.end() && scatterTimeout.MicroSeconds()) {
        cgi.InsertUnescaped("timeout", ToString(scatterTimeout.MicroSeconds()));
        iter = cgi.find(TStringBuf("timeout"));
    }
    if (iter != cgi.end()) {
        const ui64 elapsed = MicroSeconds() - GetRequestStartTime().MicroSeconds();
        ui64 timeout;
        if (!TryFromString<ui64>(iter->second, timeout)) {
            IncorrectTimeoutSignal.Signal(1);
            return EDeadlineCorrectionResult::dcrIncorrectDeadline;
        }
        TimeoutHistogramSignal.Signal(TDuration::MicroSeconds(timeout).MilliSeconds());

        RequestDeadline = TInstant::MicroSeconds(GetRequestStartTime().MicroSeconds() + timeout);
        if (elapsed >= timeout * 0.9) {
            return EDeadlineCorrectionResult::dcrRequestExpired;
        }

        iter->second = ToString(timeout - elapsed);
        return EDeadlineCorrectionResult::dcrOK;
    } else {
        NoTimeoutSignal.Signal(1);
        return EDeadlineCorrectionResult::dcrNoDeadline;
    }
}
