#include "exception.h"

#include <rtline/util/types/exception.h>

#include <library/cpp/http/misc/httpcodes.h>
#include <library/cpp/http/misc/httpreqdata.h>

#include <util/generic/buffer.h>
#include <util/stream/buffer.h>

void MakeErrorPage(IReplyContext::TPtr context, const ui32 code, const TString& error) try {
    if (!context) {
        return;
    }

    TCodedException ce(code);
    ce << error;

    TBuffer buffer;
    TBufferOutput output(buffer);
    output << ce.GetReport().GetStringRobust() << Endl;
    context->MakeSimpleReply(buffer, code);
} catch (const std::exception& e) {
    DEBUG_LOG << "cannot MakeErrorPage for" << error << ": " << FormatExc(e) << Endl;
}
