#include <drive/library/cpp/searchserver/replier.h>

#include <library/cpp/testing/unittest/registar.h>
#include <search/request/data/reqdata.h>


namespace {
    class TReplyContextMock: public IReplyContext {
    private:
        TServerRequestData RequestData;

    protected:
        const TBlob& DoGetBuf() const override {
            ythrow yexception() << "Not implemented";
        }

    public:
        TReplyContextMock(const TString& queryString)
            : RequestData(queryString.c_str())
        {
        }

        const TServerRequestData& GetRequestData() const override {
            return RequestData;
        }

        TServerRequestData& MutableRequestData() override {
            return RequestData;
        }

        const TCgiParameters& GetCgiParameters() const override {
            return GetRequestData().CgiParam;
        }

        TCgiParameters& MutableCgiParameters() override {
            return MutableRequestData().CgiParam;
        }

        TStringBuf GetUri() const override {
            return GetRequestData().ScriptName();
        }

        TInstant GetRequestStartTime() const override {
            return TInstant::MicroSeconds(RequestData.RequestBeginTime());
        }

        bool IsHttp() const override {
            ythrow yexception() << "Not implemented";
        }

        IOutputStream& Output() override {
            ythrow yexception() << "Not implemented";
        }

        void MakeSimpleReply(const TBuffer& /*buf*/, int /*code*/) override {
            FAIL_LOG("Not implemented");
        }

        void AddReplyInfo(const TString& /*key*/, const TString& /*value*/) override {
            FAIL_LOG("Not implemented");
        }
    };

    EDeadlineCorrectionResult GetCorrectionResult(const TString& queryString, const TDuration& scatterTimeout, bool sleep) {
        TReplyContextMock mock = TReplyContextMock(queryString);
        if (sleep) {
            Sleep(TDuration::MicroSeconds(1000));
        }
        return mock.DeadlineCorrection(scatterTimeout);
    }
}

Y_UNIT_TEST_SUITE(TestReplier) {
    Y_UNIT_TEST(TestDeadlineCorrection) {
        UNIT_ASSERT_EQUAL(EDeadlineCorrectionResult::dcrOK, GetCorrectionResult("timeout=10000", TDuration::Seconds(5), false));
        UNIT_ASSERT_EQUAL(EDeadlineCorrectionResult::dcrOK, GetCorrectionResult("timeout=10000", TDuration::Seconds(0), false));
        UNIT_ASSERT_EQUAL(EDeadlineCorrectionResult::dcrRequestExpired, GetCorrectionResult("timeout=100", TDuration::Seconds(0), true));
        UNIT_ASSERT_EQUAL(EDeadlineCorrectionResult::dcrRequestExpired, GetCorrectionResult("timeout=100", TDuration::Seconds(5), true));

        UNIT_ASSERT_EQUAL(EDeadlineCorrectionResult::dcrOK, GetCorrectionResult("out=100", TDuration::Seconds(5), true));
        UNIT_ASSERT_EQUAL(EDeadlineCorrectionResult::dcrOK, GetCorrectionResult("out=100", TDuration::Seconds(5), false));
        UNIT_ASSERT_EQUAL(EDeadlineCorrectionResult::dcrNoDeadline, GetCorrectionResult("out=100", TDuration::Seconds(0), false));

        UNIT_ASSERT_EQUAL(EDeadlineCorrectionResult::dcrNoDeadline, GetCorrectionResult("out=100", TDuration::Seconds(0), true));
        UNIT_ASSERT_EQUAL(EDeadlineCorrectionResult::dcrIncorrectDeadline, GetCorrectionResult("timeout=zzz", TDuration::Seconds(1), false));
    }
}
