#include "client.h"

TSelfHttpRequester::TSelfHttpRequester(const TSelfHttpRequesterConfig& config)
    : Config(config)
    , AD(new TAsyncDelivery())
{
    for (auto&& env : config.GetEnvironments()) {
        Agents.emplace(env, new NNeh::THttpClient(AD));
    }
    AD->Start(Config.GetRequestConfig().GetThreadsStatusChecker(), Config.GetRequestConfig().GetThreadsSenders());
    for (auto&& [env, agent] : Agents) {
        agent->RegisterSource("self-http-requester", Config.GetHost(env), Config.GetPort(env), Config.GetRequestConfig(), Config.GetHttps());
    }
}

TSelfHttpRequester::~TSelfHttpRequester() {
    AD->Stop();
}
