#pragma once

#include "config.h"

#include <rtline/util/network/neh.h>

class TSelfHttpRequester {
public:
    TSelfHttpRequester(const TSelfHttpRequesterConfig& config);
    ~TSelfHttpRequester();

    const TAtomicSharedPtr<NNeh::THttpClient> GetForEnv(const TSelfHttpRequesterConfig::EEnv& env) const {
        auto it = Agents.find(env);
        if (it == Agents.end()) {
            return nullptr;
        }
        return it->second;
    }

    const TSet<TCiString>& GetHeaderWhitelist() const {
        return Config.GetHeaderWhitelist();
    }

    TString GetDelegationAuthHeader() const {
        return Config.GetDelegatorAuthHeader();
    }

    TDuration GetRequestTimeout() const {
        return Config.GetRequestTimeout();
    }

private:
    TSelfHttpRequesterConfig Config;
    TAtomicSharedPtr<TAsyncDelivery> AD;
    TMap<TSelfHttpRequesterConfig::EEnv, TAtomicSharedPtr<NNeh::THttpClient>> Agents;
};
