#pragma once

#include <kernel/daemon/config/daemon_config.h>

#include <library/cpp/charset/ci_string.h>

#include <rtline/library/metasearch/simple/config.h>
#include <rtline/util/types/accessor.h>

#include <util/generic/set.h>

class TSelfHttpRequesterConfig {
public:
    enum EEnv {
        Testing /* "testing" */,
        Prestable /* "prestable" */,
        Stable /* "stable" */,
        Admin /* "admin" */,
        TestLocal /* "test_local" */,
    };

private:
    R_READONLY(TVector<EEnv>, Environments);
    R_READONLY(TSet<TCiString>, HeaderWhitelist);
    R_READONLY(TString, DelegatorAuthHeader);
    R_READONLY(NSimpleMeta::TConfig, RequestConfig);
    R_READONLY(TDuration, RequestTimeout, TDuration::Seconds(3));
    R_READONLY(bool, Https, true);

public:
    void Init(const TYandexConfig::Section* section);
    void ToString(IOutputStream& os) const;
    static TSelfHttpRequesterConfig ParseFromString(const TString& configStr);

    TString GetHost(const EEnv env) const;
    ui32 GetPort(const EEnv env) const;
};
