#include "client.h"

#include <drive/library/cpp/threading/future.h>

#include <rtline/util/json_processing.h>

#include <util/string/builder.h>
#include <library/cpp/string_utils/quote/quote.h>

bool TSendrClient::ProcessRequests(const TSet<TString>& emails, const TString& list, const TString& action, const TString& requestType, TMessagesCollector& errors) const {
   Y_ENSURE(Agent);

    NNeh::THttpRequest request;
    request.SetUri(Config.GetPathPrefix() + Config.GetAccount() + action + list);
    request.SetRequestType(requestType);
    request.AddHeader("Authorization", "Basic " + Config.GetToken());

    TMap<TString, NNeh::THttpRequest> requests;
    for (auto&& email : emails) {
        auto requestWithCgi = request;
        requestWithCgi.SetCgiData("email=" + CGIEscapeRet(email));
        requests.emplace(email, std::move(requestWithCgi));
    }

    auto responses = Agent->SendPack(requests, TInstant::Max(), Config.GetMaxInFlight(), Config.GetRequestTimeout());

    bool isSuccess = true;
    for (const auto& [email, reply] : responses) {
        if (reply.Code() != 200) {
            isSuccess = false;
            errors.AddMessage("SendrReplyError", "Email: " + email + ", code: " + ToString(reply.Code()) + ", response: " + reply.Content() + ", error: " + reply.ErrorMessage());
        }
    }
    return isSuccess;
}

bool TSendrClient::Subscribe(const TSet<TString>& emails, const TString& list, TMessagesCollector& errors) const {
   return ProcessRequests(emails, list, "/unsubscribe/list/", "DELETE", errors);
}

bool TSendrClient::Unsubscribe(const TSet<TString>& emails, const TString& list, TMessagesCollector& errors) const {
   return ProcessRequests(emails, list, "/unsubscribe/list/", "PUT", errors);
}
