#pragma once

#include "config.h"

#include <rtline/util/network/neh.h>
#include <rtline/util/types/messages_collector.h>
#include <library/cpp/tvmauth/client/facade.h>

class TSendrClient {
public:
    TSendrClient(const TSendrConfig& config)
        : Config(config)
    {
        Agent = MakeHolder<NNeh::THttpClient>(Config.GetUri(), Config.GetRequestConfig());
    }

    bool Subscribe(const TSet<TString>& emails, const TString& list, TMessagesCollector& errors) const;
    bool Unsubscribe(const TSet<TString>& emails, const TString& list, TMessagesCollector& errors) const;

private:
    bool ProcessRequests(const TSet<TString>& emails, const TString& list, const TString& action, const TString& requestType, TMessagesCollector& errors) const;

    THolder<NNeh::THttpClient> Agent;
    const TSendrConfig& Config;
};
