#include "config.h"

#include <util/stream/file.h>

void TSendrConfig::Init(const TYandexConfig::Section* section) {
    Uri = section->GetDirectives().Value<TString>("Uri", Uri);
    Account = section->GetDirectives().Value<TString>("Account", Account);

    Token = section->GetDirectives().Value<TString>("Token", Token);
    TokenPath = section->GetDirectives().Value<TString>("TokenPath", TokenPath);
    if (!Token && TokenPath) {
        Token = Strip(TFileInput(TokenPath).ReadAll());
    }
    AssertCorrectConfig(!!Token, "TokenPath and Token path for sender.yandex-team.ru not provided");

    MaxInFlight = section->GetDirectives().Value<ui32>("MaxInFlight", MaxInFlight);

    RequestTimeout = section->GetDirectives().Value<TDuration>("RequestTimeout", RequestTimeout);
    const TYandexConfig::TSectionsMap children = section->GetAllChildren();
    auto it = children.find("RequestConfig");
    if (it != children.end()) {
        RequestConfig.InitFromSection(it->second);
    }
}

void TSendrConfig::ToString(IOutputStream& os) const {
    os << "Uri: " << Uri << Endl;
    os << "Account: " << Account << Endl;
    os << "TokenPath: " << TokenPath << Endl;
    os << "MaxInFlight: " << MaxInFlight << Endl;
    os << "RequestTimeout: " << RequestTimeout << Endl;
    os << "<RequestConfig>" << Endl;
    RequestConfig.ToString(os);
    os << "</RequestConfig>" << Endl;
}

TSendrConfig TSendrConfig::ParseFromString(const TString& configStr) {
    TSendrConfig result;
    TAnyYandexConfig config;
    CHECK_WITH_LOG(config.ParseMemory(configStr.data()));
    result.Init(config.GetRootSection());
    return result;
}
