#pragma once

#include <rtline/library/deprecated/async_impl/config.h>
#include <rtline/util/types/accessor.h>

class TSendrConfig {
    R_FIELD(TString, Uri, "https://sender.yandex-team.ru/");
    R_FIELD(TString, PathPrefix, "api/0/");
    R_READONLY(TString, Token);
    R_READONLY(TString, TokenPath);
    R_READONLY(TString, Account, "yandex.carshare");
    R_READONLY(TString, OverridenRecipient);
    R_FIELD(NSimpleMeta::TConfig, RequestConfig);
    R_FIELD(TDuration, RequestTimeout, TDuration::Seconds(10));
    R_READONLY(ui32, MaxInFlight, 10);

public:
    static TSendrConfig ParseFromString(const TString& configStr);
    void Init(const TYandexConfig::Section* section);
    void ToString(IOutputStream& os) const;
};
