#include "client.h"

NThreading::TFuture<TSocialProfilesData> TSocialAPIClient::GetSocialData(const ui64 uid) const {
    NNeh::THttpRequest request;
    request
        .SetUri(Config.GetProfilesListUri())
        .SetCgiData("uid=" + ToString(uid))
        .AddHeader("X-Ya-Service-Ticket", TvmClient->GetServiceTicketFor(Config.GetDestinationTvmId()));

    return Agent->SendAsync(request, Now() + Config.GetRequestTimeout()).Apply([](const NThreading::TFuture<NUtil::THttpReply>& r) {
        const auto& reply = r.GetValue();
        return TSocialProfilesData::FromHttpReply(reply.Content(), reply.Code());
    });
}
