#pragma once

#include "config.h"
#include "model.h"

#include <library/cpp/tvmauth/client/facade.h>

class TSocialAPIClient {
public:
    TSocialAPIClient(const TSocialAPIClientConfig& config, TAtomicSharedPtr<NTvmAuth::TTvmClient> tvmClient)
        : Config(config)
        , AD(new TAsyncDelivery())
        , Agent(new NNeh::THttpClient(AD))
        , TvmClient(tvmClient)
    {
        CHECK_WITH_LOG(!!TvmClient);
        AD->Start(Config.GetRequestConfig().GetThreadsStatusChecker(), Config.GetRequestConfig().GetThreadsSenders());
        Agent->RegisterSource("social_api", Config.GetHost(), Config.GetPort(), Config.GetRequestConfig(), true);
    }
    ~TSocialAPIClient() {
        AD->Stop();
    }

    NThreading::TFuture<TSocialProfilesData> GetSocialData(const ui64 uid) const;

private:
    TSocialAPIClientConfig Config;
    TAtomicSharedPtr<TAsyncDelivery> AD;
    THolder<NNeh::THttpClient> Agent;
    TAtomicSharedPtr<NTvmAuth::TTvmClient> TvmClient;
};
