#pragma once

#include <kernel/daemon/config/daemon_config.h>

#include <library/cpp/json/json_reader.h>
#include <library/cpp/logger/global/global.h>
#include <library/cpp/mediator/global_notifications/system_status.h>
#include <library/cpp/string_utils/url/url.h>

#include <rtline/library/deprecated/async_impl/async_impl.h>
#include <rtline/util/types/accessor.h>

#include <util/stream/file.h>


class TSocialAPIClientConfig {
    R_READONLY(TString, Host);
    R_READONLY(ui32, Port, 0);
    R_READONLY(ui32, SelfTvmId, 0);
    R_READONLY(ui32, DestinationTvmId, 0);
    R_READONLY(TString, ProfilesListUri, "api/profiles");
    R_READONLY(TDuration, RequestTimeout, TDuration::Seconds(10));
    R_READONLY(NSimpleMeta::TConfig, RequestConfig);

public:
    void Init(const TYandexConfig::Section* section);
    void ToString(IOutputStream& os) const;

    static TSocialAPIClientConfig ParseFromString(const TString& configStr);
};
