#pragma once

#include <rtline/util/json_processing.h>
#include <rtline/util/types/accessor.h>

#include <library/cpp/json/json_reader.h>

class TSocialProfile {
    R_READONLY(TVector<TString>, Addresses);
    R_READONLY(TString, Provider);
    R_READONLY(TString, ProviderCode);
    R_READONLY(TString, Username);
    R_READONLY(ui64, ProfileId, 0);
    R_READONLY(TString, Userid);
    R_READONLY(ui64, Uid, 0);

public:
    bool DeserializeFromJson(const NJson::TJsonValue& json);
    NJson::TJsonValue SerializeToJson() const;
};

class TSocialProfilesData {
    R_READONLY(TVector<TSocialProfile>, Profiles);
    R_FIELD(bool, Broken, false);

public:
    TSocialProfilesData(const TVector<TSocialProfile>& profiles, const bool broken)
        : Profiles(profiles)
        , Broken(broken)
    {
    }

    static TSocialProfilesData FromHttpReply(const TString& content, const ui32 code);
    NJson::TJsonValue SerializeToJson() const;
};
